/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.UGen;

public class GranulateRandom
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
    public UGen.UGenInput grainLenMin = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLenMin = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLenMin = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput grainLenMax = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLenMax = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLenMax = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    private boolean insideGrain;
    private float timeSinceGrainStart;
    private float timeSinceGrainStop;
    private float timeStep;
    private float fadeLength = 0.0025f;
    private float grainLength = 0.01f;
    private float spaceLength = 0.02f;
    private float fadeLengthMin = 0.0025f;
    private float grainLengthMin = 0.01f;
    private float spaceLengthMin = 0.02f;
    private float fadeLengthMax = 0.0025f;
    private float grainLengthMax = 0.01f;
    private float spaceLengthMax = 0.02f;
    private float minAmp = 0.0f;
    private float maxAmp = 1.0f;

    public GranulateRandom() {
        this(0.01f, 0.02f, 0.0025f, 0.1f, 0.2f, 0.025f, 0.0f, 1.0f);
    }

    public GranulateRandom(float f, float f2, float f3, float f4, float f5, float f6) {
        this(f, f2, f3, f4, f5, f6, 0.0f, 1.0f);
    }

    public GranulateRandom(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.setAllParameters(f, f2, f3, f4, f5, f6, f7, f8);
        this.insideGrain = false;
        this.timeSinceGrainStart = 0.0f;
        this.timeSinceGrainStop = 0.0f;
        this.timeStep = 0.0f;
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStep = 1.0f / this.sampleRate();
    }

    public void setAllTimeParameters(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setAllParameters(f, f2, f3, f4, f5, f6, this.minAmp, this.maxAmp);
    }

    public void setAllParameters(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.grainLenMin.setLastValue(f);
        this.grainLenMax.setLastValue(f4);
        this.fadeLenMin.setLastValue(f3);
        this.fadeLenMax.setLastValue(f6);
        this.spaceLenMin.setLastValue(f2);
        this.spaceLenMax.setLastValue(f5);
        this.grainLengthMin = f;
        this.spaceLengthMin = f2;
        this.fadeLengthMin = f3;
        this.grainLengthMax = f4;
        this.spaceLengthMax = f5;
        this.fadeLengthMax = f6;
        this.minAmp = f7;
        this.maxAmp = f8;
    }

    private void checkFadeLength() {
        this.fadeLength = Math.min(this.fadeLength, this.grainLength / 2.0f);
    }

    private float randomBetween(float f, float f2) {
        return (f2 - f) * (float)Math.random() + f;
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (this.insideGrain) {
            float f = this.maxAmp;
            if (this.timeSinceGrainStart < this.fadeLength) {
                f *= this.timeSinceGrainStart / this.fadeLength;
            } else if (this.timeSinceGrainStart > this.grainLength - this.fadeLength) {
                f *= (this.grainLength - this.timeSinceGrainStart) / this.fadeLength;
            }
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f * this.audio.getLastValues()[i];
            }
            this.timeSinceGrainStart += this.timeStep;
            if (this.timeSinceGrainStart > this.grainLength) {
                this.timeSinceGrainStop = 0.0f;
                this.insideGrain = false;
                this.spaceLengthMin = this.spaceLenMin.getLastValue();
                this.spaceLengthMax = this.spaceLenMax.getLastValue();
                this.spaceLength = this.randomBetween(this.spaceLengthMin, this.spaceLengthMax);
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.minAmp;
            }
            this.timeSinceGrainStop += this.timeStep;
            if (this.timeSinceGrainStop > this.spaceLength) {
                this.timeSinceGrainStart = 0.0f;
                this.insideGrain = true;
                this.grainLengthMin = this.grainLenMin.getLastValue();
                this.grainLengthMax = this.grainLenMax.getLastValue();
                this.grainLength = this.randomBetween(this.grainLengthMin, this.grainLengthMax);
                this.fadeLengthMin = this.fadeLenMin.getLastValue();
                this.fadeLengthMax = this.fadeLenMax.getLastValue();
                this.fadeLength = this.randomBetween(this.fadeLengthMin, this.fadeLengthMax);
                this.checkFadeLength();
            }
        }
    }
}

